# -*- coding: utf-8 -*-
"""
Created on Thu May  2 11:08:07 2024

@author: SA-Lenovo
"""
# Import the required Python libraries 
import matplotlib.pyplot as plt 
from scipy import interpolate 
import numpy as np 


#%% 1-D Interpolation
# Initialize input values x and y 
x = np.arange(0, 10) 
y = x**2

# Interpolation 
temp = interpolate.interp1d(x, y) 
xnew = np.arange(0, 9, 0.2) 
ynew = temp(xnew) 

plt.title("1-D Interpolation") 
plt.plot(x, y, '*', xnew, ynew, '-', color="green") 
plt.show() 

#%% Spline Interpolation

# Initialize the input values 
x = np.arange(0, 10) 
y = np.cos(x**3) 

# Interpolation 
# To find the spline representation of a 
# curve in a 2-D plane using the function 
# splrep 
temp = interpolate.splrep(x, y, s=0) 
xnew = np.arange(0, np.pi**2, np.pi/100) 
ynew = interpolate.splev(xnew, temp, der=0) 

plt.figure() 

plt.plot(x, y, 'r*', \
         x, y, 'b', \
         xnew, ynew, 'g') 

plt.legend(['True', 'Linear', 'Cubic Spline']) 
plt.axis([-0.1, 6.5, -1.1, 1.1]) 
plt.title('Cubic-spline Interpolation in Python') 
plt.show() 

#%% Univariate Spline
# The scipy.interpolate.UnivariateSpline is used to fit a spline
# y = spl(x) of degree k to the provided x, y data. s specifies
# the number of knots by specifying a smoothing condition.

rng = np.random.default_rng()
x = np.linspace(-3, 3, 50)
y = np.exp(-x**2) + 0.1 * rng.standard_normal(50)
plt.plot(x, y, 'ro', ms=5)

# Use the default value for the smoothing parameter
spl = interpolate.UnivariateSpline(x, y)

xs = np.linspace(-3, 3, 1000)
plt.plot(xs, spl(xs), 'g', lw=3)

# Manually change the amount of smoothing
spl.set_smoothing_factor(0.5)
plt.plot(xs, spl(xs), 'b', lw=3)
plt.show()