# -*- coding: utf-8 -*-
"""
Created on Wed Dec 14 21:28:17 2022

@author: SA-Lenovo
"""
import cv2 as cv
import os

path = os.getcwd()
files = []
myColor = [(0, 0, 255), (0, 255, 0),(255, 0, 0), \
           (0, 255, 255), (255, 255, 0),(255, 0, 255) ]

# r=root, d=directories, f = files
files = [os.path.join(r, file) for r, d, f in os.walk(path) for file in f if 'jump_1' in file]

img = cv.imread(files[0], cv.IMREAD_UNCHANGED)
vidsize = (img.shape[1], img.shape[0])
out = cv.VideoWriter('jumpLabel.avi', cv.VideoWriter_fourcc(*'XVID'), 15, vidsize)
#%%
for i, f in enumerate(files):
    print(f"Image {i+1} : {os.path.basename(f)} is being processed.")
    # Read the image
    BGR = cv.imread(f)
    if BGR is None:
        print(f'Could not open the image {f} or find it:', BGR)
        exit(0)        
    #%%
    # Convert to the gray
    imgray = cv.cvtColor(BGR, cv.COLOR_BGR2GRAY) # Convert to Gray
    # median filter salt&pepper
    filtered = cv.medianBlur(imgray, 3)
    # Convert to the Black & White binary image
    _ ,bw = cv.threshold(filtered, 127, 255, cv.THRESH_BINARY)

    # cv.imshow('Original image',BGR)
    # cv.waitKey(0)
    # cv.imshow('Gray image', imgray)
    # cv.waitKey(0)
    # cv.imshow('Filtered', filtered)
    # cv.waitKey(0) 
    
    totalLabels, label_ids, values, centroid = cv.connectedComponentsWithStats(bw)
    # put text and highlight the center
    for i in range(1, len(centroid)):
     
        cv.circle(BGR, (int(centroid[i][0]), int(centroid[i][1])), 3, myColor[i-1], -1)
        cv.putText(BGR, "{:.2f}, {:.2f}".format(centroid[i][0], centroid[i][1]), \
                   (int(centroid[i][0]) + 25, int(centroid[i][1]) + 5), \
                    cv.FONT_HERSHEY_SIMPLEX, 0.5, (255, 255, 255), 1, cv.LINE_AA)
    
    
    cv.imshow('Labelled image', BGR)
    out.write(BGR)
    cv.waitKey(100)
out.release()
cv.waitKey(5)    
cv.destroyAllWindows()